% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prism_station_md.R
\name{get_prism_station_md}
\alias{get_prism_station_md}
\title{Extract metadata on the stations used to generate a particular day/variable}
\usage{
get_prism_station_md(type, minDate = NULL, maxDate = NULL, dates = NULL)
}
\arguments{
\item{type}{The type of data to get metadata for, must be "ppt", "tmean", "tmin", or "tmax".}

\item{minDate}{a valid iso-8601 (e.g. YYYY-MM-DD) date. The first date to extract metadata for.}

\item{maxDate}{a valid iso-8601 (e.g. YYYY-MM-DD) date. The last date to extract metadata for.}

\item{dates}{a vector of iso-8601 formatted dates to extract metadata for, can also be a single date.}
}
\value{
A \code{tbl_df} containing metadata on the stations used for each day/variable.
}
\description{
This only extracts metadata from daily PRISM data.
}
