% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statisticalDiagram.R
\name{statisticalDiagram}
\alias{statisticalDiagram}
\title{Draw statistical diagram}
\usage{
statisticalDiagram(no = 1, radx = 0.1, rady = 0.04, xmargin = 0.01,
  arrowlabel = TRUE, labels = list(), whatLabel = "name",
  fit = NULL, estimateTable = NULL, covar = list(),
  includeLatentVars = FALSE)
}
\arguments{
\item{no}{process macro model number}

\item{radx}{horizontal radius of the box.}

\item{rady}{vertical radius of the box.}

\item{xmargin}{horizontal margin of plot}

\item{arrowlabel}{logical whether or not draw arrowlabel}

\item{labels}{A character list}

\item{whatLabel}{What should the edge labels indicate in the path diagram? Choices are c("est","std","name")}

\item{fit}{An object of class lavaan. Result of lavaan::sem()}

\item{estimateTable}{A data.frame}

\item{covar}{Optional list of covariates}

\item{includeLatentVars}{A logical}
}
\description{
Draw statistical diagram
}
\examples{
statisticalDiagram(no=1)
covar=list(name=c("posemot","ideology","sex"),site=list(c("Y"),c("Y"),c("Y")))
statisticalDiagram(no=1,covar=covar)
covar=list(name=c("posemot","ideology","sex"),site=list(c("Mi","Y"),c("Mi","Y"),c("Mi","Y")))
statisticalDiagram(no=4,covar=covar)
statisticalDiagram(no=8,covar=covar)
}
