% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renderer.R
\name{renderer_leaflet}
\alias{renderer_leaflet}
\title{Render as graph on a geographical map}
\usage{
renderer_leaflet(node_coordinates, edge_coordinates = data.frame(act_from
  = character(0), act_to = character(0), lat = numeric(0), lng =
  numeric(0), stringsAsFactors = FALSE),
  layer = c(paste0("new L.TileLayer('", tile, "',"),
  paste0("{ attribution : '", attribution_osm(), "'})")),
  tile = "http://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png",
  options = list(), grayscale = TRUE, icon_act = icon_marker(),
  icon_start = icon_circle(), icon_end = icon_circle(),
  scale_max = 4, scale_min = 0.25)
}
\arguments{
\item{node_coordinates}{A data frame with node coordinates in the format `act`, `lat`, `lng`.}

\item{edge_coordinates}{A data frame with additional edge coordinates in the format `act_from`, `act_to`, `lat`, `lng`.}

\item{layer}{The JavaScript code used to create a Leaflet layer. A TileLayer is used as default value.}

\item{tile}{The URL to be used for the standard Leaflet TileLayer.}

\item{options}{A named list of leaflet options, such as the center point of the map and the initial zoom level.}

\item{grayscale}{Whether to apply a grayscale filter to the map.}

\item{icon_act}{The SVG code used for the activity icon.}

\item{icon_start}{The SVG code used for the start icon.}

\item{icon_end}{The SVG code used for the end icon.}

\item{scale_max}{The maximum factor to be used to scale the process map with when zooming out.}

\item{scale_min}{The minimum factor to be used to scale the process map with when zooming in.}
}
\value{
A rendering function to be used with \code{\link{animate_process}}
}
\description{
This renderer uses Leaflet to draw the nodes and egdes of the process map on a geographical map.
}
\examples{
data(example_log)

# Animate the example process with activities placed in some locations
animate_process(example_log,
  renderer = renderer_leaflet(
    node_coordinates = data.frame(
       act = c("A", "B", "C", "D", "Start", "End"),
       lat = c(63.443680, 63.426925, 63.409207, 63.422336, 63.450950, 63.419706),
       lng = c(10.383625, 10.396972, 10.406418, 10.432119, 10.383368, 10.252347),
       stringsAsFactors = FALSE),
    edge_coordinates = data.frame(
       act_from = c("B"),
       act_to = c("C"),
       lat = c(63.419207),
       lng = c(10.386418),
       stringsAsFactors = FALSE),
    options = list(center = c(63.412273, 10.399590), zoom = 12)),
  duration = 5, repeat_count = Inf)

}
\seealso{
animate_process
}
