% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{proffer-package}
\alias{proffer-package}
\alias{proffer}
\title{proffer: profile R code with pprof}
\description{
It can be challenging to find sources of
slowness in large workflows, and the proffer package can help.
Proffer runs R code and displays summaries
to show where the code is slowest. Proffer leverages
the pprof utility to create highly efficient, clear, easy-to-read
interactive displays that help users find ways to reduce runtime.
The package also contains helpers to convert profiling data
to and from pprof format and visualize existing profiling data files.
For documentation, visit \url{https://r-prof.github.io/proffer}.
}
\examples{
# TBD
\dontrun{
# Start a pprof virtual server in the background.
px <- pprof(replicate(1e2, sample.int(1e4)))
# Terminate the server.
px$kill()
}
}
\references{
\url{https://github.com/r-prof/proffer}
}
\author{
William Michael Landau \email{will.landau@gmail.com}
}
