% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_projections.R
\name{merge_projections}
\alias{merge_projections}
\title{Merge a list of projections objects}
\usage{
merge_projections(x)
}
\arguments{
\item{x}{A `list` of `projections` objects to be merged.}
}
\description{
This function merges `projections` objects, binding them by columns, making
sure that they all use the same dates, adding rows of '0' where needed.
}
\examples{

## generate toy data
dates <- Sys.Date() + c(0, 0, 2, 5, 6, 6, 7)
i <- incidence::incidence(dates)
si <- c(0.2, 0.5, 0.2, 0.1)
R0 <- 3.5

## make several projections objects
x <- lapply(1:10,
            function(j)
              project(x = i,
                      si = si,
                      R = R0,
                      n_sim = 2 * j,
                      R_fix_within = TRUE,
                      n_days = j,
                      model = "poisson"
                      ))
## see all dimensions
lapply(x, dim)
merge_projections(x)
}
\author{
Thibaut Jombart
}
