% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promotion_impact.R
\name{promotionImpact}
\alias{promotionImpact}
\title{estimate effectiveness of promotions}
\usage{
promotionImpact(data, promotion, time.field = "date",
  target.field = "value", dummy.field = NULL, trend = TRUE,
  period = "auto", structural.change = FALSE, trend.param = 0.05,
  period.param = 3, var.type = "smooth", smooth.except.date = NULL,
  smooth.bandwidth = 2, smooth.origin = "all", smooth.var.sum = TRUE,
  logged = TRUE, differencing = TRUE, synergy.promotion = FALSE,
  synergy.var = NULL, allow.missing = TRUE)
}
\arguments{
\item{data}{Dataframe containing date, target variable, and some additional time dummies that the researcher wants to account for.}

\item{promotion}{Dataframe containing promotion ID, start date, end date, promotion tag(type). Might include daily payments associated with the promotion.}

\item{time.field}{Specify the date field of 'data'.}

\item{target.field}{Specify the target field of 'data'.}

\item{dummy.field}{Specify the additional time dummies of 'data'.}

\item{trend}{TRUE to incorporate trend component, FALSE to exclude the trend component.}

\item{period}{NULL to exclude any periodicity from the model, 'auto' to automatically determine the period, certain numeric value(e.g. '30.5' for month) to manually specify the period}

\item{structural.change}{TRUE to incorporate structural changes in the intercept(baseline)}

\item{trend.param}{Flexibility of trend component. Default is 0.05, and as this value becomes larger, the trend component will be more flexible.}

\item{period.param}{Flexibility of period component. Default is 3, and as this value becomes larger, the period component will be more flexible.}

\item{var.type}{'smooth' to use smoothed promotion variables, 'dummy' to use dummy promotion variables}

\item{smooth.except.date}{Date value that will be excluded from the smoothing process. eg) '01' to exclude every start day of a month}

\item{smooth.bandwidth}{Bandwidth of local polynomial regression used in the smoothing process. Default value is 2.}

\item{smooth.origin}{'all' to estimate a global smoothing function for all promotions. 'tag' to estimate different smoothing functions for different promotion types(tags).}

\item{smooth.var.sum}{If TRUE, the smoothing values for times when multiple promotions in a single tag overlap will be the values from the latest promotion. Otherwise, the values will be added(default).}

\item{logged}{TRUE to take logs to the target variable and the trend/period component}

\item{differencing}{TRUE to first difference the target variable, smoothed regressors, and the trend/period component values}

\item{synergy.promotion}{TRUE to incorporate synergy between promotion tags.}

\item{synergy.var}{Specify the synergy variables. 'names of fields' between each promotion tag and other variables. eg) c('month_start') to incorparate synergy between each promotion tag and 'month_start'.}

\item{allow.missing}{TRUE to allow missing data in promotion sales during the promotion period}
}
\description{
promotionImpact
}
\details{
promotionImpact is for analysis & measurement of the effectiveness of promotions, controlling for some prespeficied or estimated control variables.
}
\examples{
pri1 <- promotionImpact(data=sim.data, promotion=sim.promotion, 
                       time.field = 'dt', target.field = 'simulated_sales', 
                       trend = FALSE, period = NULL, structural.change = FALSE,
                       logged = TRUE, differencing = TRUE, synergy.promotion = FALSE,
                       synergy.var = NULL, allow.missing = TRUE)
}
