% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prophet.R
\name{plot.prophet}
\alias{plot.prophet}
\title{Plot the prophet forecast.}
\usage{
\method{plot}{prophet}(x, fcst, uncertainty = TRUE, plot_cap = TRUE,
  xlabel = "ds", ylabel = "y", ...)
}
\arguments{
\item{x}{Prophet object.}

\item{fcst}{Data frame returned by predict(m, df).}

\item{uncertainty}{Boolean indicating if the uncertainty interval for yhat
should be plotted. Must be present in fcst as yhat_lower and yhat_upper.}

\item{plot_cap}{Boolean indicating if the capacity should be shown in the
figure, if available.}

\item{xlabel}{Optional label for x-axis}

\item{ylabel}{Optional label for y-axis}

\item{...}{additional arguments}
}
\value{
A ggplot2 plot.
}
\description{
Plot the prophet forecast.
}
\examples{
\dontrun{
history <- data.frame(ds = seq(as.Date('2015-01-01'), as.Date('2016-01-01'), by = 'd'),
                      y = sin(1:366/200) + rnorm(366)/10)
m <- prophet(history)
future <- make_future_dataframe(m, periods = 365)
forecast <- predict(m, future)
plot(m, forecast)
}

}

