% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/641.PosteriorProbs.R
\name{probPOS}
\alias{probPOS}
\title{Bayesian posterior Probabilities}
\usage{
probPOS(n, a, b, th)
}
\arguments{
\item{n}{- Number of trials}

\item{a}{- Prior Parameters}

\item{b}{- Prior Parameters}

\item{th}{- Theta value seeking Pr(Theta/X < th)}
}
\value{
A dataframe with
 \item{x}{ Number of successes}
 \item{PosProb}{ Posterior probability}
}
\description{
Bayesian posterior Probabilities
}
\details{
Computes probability of the event \eqn{p < p0} (p0 is specified in [0, 1]) based
on posterior distribution of Beta-Binomial model with given parameters for prior Beta
distribution for all \eqn{x = 0, 1, 2......n } where \code{n} is the number of trials
}
\examples{
n=5;  a=0.5; b=0.5; th=0.5;
probPOS(n,a,b,th)
}
\references{
[1] 2002 Gelman A, Carlin  JB, Stern HS and Dunson DB
Bayesian Data Analysis, Chapman & Hall/CRC
[2] 2006  Ghosh M, Delampady M and Samanta T.
An introduction to Bayesian analysis: Theory and Methods. Springer, New York
}
\seealso{
Other Miscellaneous  functions for Bayesian method: \code{\link{empericalBAx}},
  \code{\link{empericalBA}}, \code{\link{probPOSx}},
  \code{\link{probPREx}}, \code{\link{probPRE}}
}
