% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop2prob.R
\name{abstract}
\alias{abstract}
\title{Abstract Two propr Objects}
\usage{
abstract(x, y, dt, colBy = "Adjusted", cutoff = 0.01)
}
\arguments{
\item{x, y}{A \code{propr} object.}

\item{dt}{A \code{data.table}. The result from
\code{prop2prob(x, y)}.}

\item{colBy}{A character string. The column in \code{dt}
used to select statistically significant pairs.}

\item{cutoff}{A numeric scalar. The value of \code{colBy}
used to select statistically significant pairs.}
}
\value{
Returns an abstracted \code{propr} object.
}
\description{
This function abstracts a new \code{propr} object from
 two existing \code{propr} objects. The two \code{propr}
 objects should not have any overlapping samples. Typically,
 the two objects represent different experimental groups.
 The resultant abstracted object inherits all plot functions
 available for the original \code{propr} objects.
}
\details{
The abstracted \code{propr} object has the following properties:
 The \code{@counts} and \code{@logratio} slots contain a
 join of the original slots via \code{rbind}. Meanwhile,
 the \code{@matrix} slot contains a difference matrix defined as
 \code{tanh(atanh(x@matrix) - atanh(y@matrix))}. The \code{@pairs}
 slot contains an index of all statistically significant pairs,
 toggled via the argument \code{dt}.

Visualizing the difference matrix with \code{dendrogram} may
 help summarize the results of \code{prop2prob}. Note that the
 difference matrix now also informs co-cluster assignment for
 the \code{bucket}, \code{prism}, and \code{bokeh} plots.
 Otherwise, most abstracted plots should match those made using
 \code{perb(rbind(x@counts, y@counts))}.
}
\examples{
library(propr)
data(mail)
mail1 <- mail[1:2, ]
mail2 <- mail[3:4, ]
rho1 <- perb(mail1)
rho2 <- perb(mail2)
abstract(rho1, rho2)
}
\seealso{
\code{\link{propr}}, \code{\link{prop2prob}}
}

