% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-get.R
\name{getNetwork}
\alias{getNetwork}
\title{Get Network from Object}
\usage{
getNetwork(object, cutoff = NA, propr.object, propr.cutoff = NA,
  thetad.object, thetad.cutoff = NA, thetae.object, thetae.cutoff = NA,
  col1, col2, include = NA, or = TRUE, d3 = FALSE)
}
\arguments{
\item{object}{Any \code{propr} or \code{propd} object.}

\item{cutoff}{A cutoff argument for \code{object}, passed
to \code{\link{getResults}}.}

\item{propr.object, thetad.object, thetae.object}{A \code{propr}
object or an appropriate \code{propd} object.}

\item{propr.cutoff, thetad.cutoff, thetae.cutoff}{A cutoff
argument passed to \code{\link{getResults}}.}

\item{col1}{A character vector. Specifies which nodes
to color \code{red} or \code{blue}, respectively.}

\item{col2}{A character vector. Specifies which nodes
to color \code{red} or \code{blue}, respectively.}

\item{include}{This argument indicates which features by
name should belong to a pair for that pair to get included
in the results. Subset performed by
\code{Partner \%in\% subset | Pair \%in\% subset}.}

\item{or}{A boolean. If \code{FALSE}, \code{include} subsets
by \code{Partner \%in\% subset & Pair \%in\% subset}.}

\item{d3}{A boolean. Use \code{rgl} to plot 3D network.}
}
\value{
A network object.
}
\description{
This function provides a unified wrapper to build networks
 from \code{propr} and \code{propd} objects.
}
