% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prospectr.R
\docType{package}
\name{prospectr-package}
\alias{prospectr-package}
\alias{prospectr}
\title{Overview of the functions in the prospectr package}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}

Misc functions for spectral data
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

This package implements a number of \code{R} functions useful for
pre-processing spectral data well as for selecting representaive samples/spectra.
The functions included here are particularly useful in Near-Infrarred and Infrared
Spectroscopy applications.
}
\details{
Currently, the following preprocessing functions are available:

\itemize{
\item{\code{\link{resample}}}
\item{\code{\link{resample2}}}
\item{\code{\link{movav}}}
\item{\code{\link{standardNormalVariate}}}
\item{\code{\link{msc}}}
\item{\code{\link{detrend}}}
\item{\code{\link{baseline}}}
\item{\code{\link{blockScale}}}
\item{\code{\link{blockNorm}}}
\item{\code{\link{binning}}}
\item{\code{\link{savitzkyGolay}}}
\item{\code{\link{gapDer}}}
\item{\code{\link{continuumRemoval}}}
}

For the selection of representative samples/observations for calibrating
spectral models the following functions ca be used:

\itemize{
\item{\code{\link{naes}}}
\item{\code{\link{honigs}}}
\item{\code{\link{shenkWest}}}
\item{\code{\link{kenStone}}}
\item{\code{\link{duplex}}}
\item{\code{\link{puchwein}}}
}

Other useful functions are also available:

\itemize{
\item{\code{\link{read_nircal}}}
\item{\code{\link{readASD}}}
\item{\code{\link{spliceCorrection}}}
\item{\code{\link{cochranTest}}}
}
}
\seealso{
Useful links:
\itemize{
\item \url{https://github.com/l-ramirez-lopez/prospectr}
\item Report bugs at \url{https://github.com/l-ramirez-lopez/prospectr/issues}
}
}
\author{
\strong{Maintainer}: Leonardo Ramirez-Lopez \email{ramirez.lopez.leo@gmail.com}

Authors:
\itemize{
\item Antoine Stevens (\href{https://orcid.org/0000-0002-1588-7519}{ORCID})

\item Leonardo Ramirez-Lopez (\href{https://orcid.org/0000-0002-5369-5120}{ORCID})
}
}
