% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{get.used.data}
\alias{get.used.data}
\alias{get.created.data}
\alias{get.updated.data}
\title{Get data used and created by a statement}
\usage{
get.used.data(adj.graph, proc.node.id)

get.created.data(adj.graph, proc.node.id)

get.updated.data(adj.graph, proc.node.id)
}
\arguments{
\item{adj.graph}{the adjacency matrix}

\item{proc.node.id}{the id of the procedure node.}
}
\value{
the ids of the data nodes that are used by the specified procedure node.  
  Returns NULL if there is no node with the given id, the id is not for 
  a procedure node, or the procedure node does not use any data nodes.  The last case
  can occur, for example, if the procedure node represents a statement where 
  a constant is assigned to a variable.

the ids of the data nodes that are created by the specified procedure node.  
  Returns NULL if there is no node with the given id, the id is not for 
  a procedure node, or the procedure node does not create any data nodes.  The last case
  can occur, for example, if the procedure node represents a statement where 
  the statement prints a constant string.

the ids of the data nodes that are updated by the specified procedure node.  
  Returns NULL if there is no node with the given id, the id is not for 
  a procedure node, or the procedure node does not update any data.
}
\description{
get.used.data returns the data nodes that this procedure node uses

A procedure node represents a top-level statement.  The data created by the
statement can be the variables set, output files written to, plots created,
error or warning messages created.
}
\details{
A procedure node represents a top-level statement.  The data used by the
statement are the variables used in expressions or input files or URLs 
read from.
}
\examples{
adj.graph <- create.graph(system.file("testdata", "basic.json", package = "provGraphR"))
get.used.data (adj.graph, "p11")

get.created.data (adj.graph, "p11")

get.updated.data (adj.graph, "p5")

}
\seealso{
\code{\link{create.graph}}

\code{\link{create.graph}}

\code{\link{create.graph}}
}
