% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/botev.R
\name{botev}
\alias{botev}
\title{Compute the optimal kernel bandwidth}
\usage{
botev(x)
}
\arguments{
\item{x}{a vector of ordinal data}
}
\value{
a scalar value with the optimal bandwidth
}
\description{
Uses the diffusion algorithm of Zdravko Botev (2011)
to calculate the bandwidth for kernel density estimation
}
\examples{
fname <- system.file("DZ.csv",package="provenance")
bw <- botev(read.distributional(fname)$x$N1)
print(bw)
}
\author{
Dzdravko Botev
}
\references{
Botev, Z. I., J. F. Grotowski, and
D. P. Kroese. "Kernel density estimation via diffusion." The Annals
of Statistics 38.5 (2010): 2916-2957.
}

