% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provenance.R
\name{read.densities}
\alias{read.densities}
\title{Read a .csv file with mineral and rock densities}
\usage{
read.densities(fname)
}
\arguments{
\item{fname}{a string with the path to the .csv file}
}
\value{
a vector with mineral and rock densities
}
\description{
Reads a data table containing densities to be used for
hydraulic sorting corrections (minsorting and srd functions)
}
\examples{
data(Namib,densities)
N8 <- subset(Namib$HM,select="N8")
distribution <- minsorting(N8,densities,phi=2,sigmaphi=1,medium="air",by=0.05)
plot(distribution)
}

