% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.distributional}
\alias{plot.distributional}
\title{Plot continuous data as histograms or cumulative age distributions}
\usage{
\method{plot}{distributional}(x, snames = NULL, annotate = TRUE,
  CAD = FALSE, pch = NA, verticals = TRUE, colmap = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{distributional}}

\item{snames}{a string or a vector of string with the names of the
samples that need plotting if \code{snames} is a vector, then
the function will default to a CAD.}

\item{annotate}{boolean flag indicating whether the x- and y-axis
should be labeled}

\item{CAD}{boolean flag indicating whether the data should be
plotted as a cumulative age distribution or a histogram. For
multi-sample plots, the function will override this value with
\code{TRUE}.}

\item{pch}{an optional symbol to mark the sample points along the
CAD}

\item{verticals}{boolean flag indicating if the horizontal lines of
the CAD should be connected by vertical lines}

\item{colmap}{an optional string with the name of one of R's
built-in colour palettes (e.g., heat.colors, terrain.colors,
topo.colors, cm.colors), which are to be used for plotting the
data.}

\item{...}{optional arguments to the generic \code{plot} function}
}
\description{
Plot one or several samples from a \code{distributional} dataset as
a histogram or Cumulative Age Distributions (CAD).
}
\examples{
data(Namib)
plot(Namib$DZ,c('N1','N2'))
}

