% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolbox.R
\name{amalgamate}
\alias{amalgamate}
\alias{amalgamate.default}
\alias{amalgamate.compositional}
\alias{amalgamate.counts}
\alias{amalgamate.SRDcorrected}
\title{Group components of a composition}
\usage{
amalgamate(X, ...)

\method{amalgamate}{default}(X, ...)

\method{amalgamate}{compositional}(X, ...)

\method{amalgamate}{counts}(X, ...)

\method{amalgamate}{SRDcorrected}(X, ...)
}
\arguments{
\item{X}{a compositional dataset}

\item{...}{a series of new labels assigned to strings or vectors of
strings denoting the components that need amalgamating}
}
\value{
an object of the same class as \code{X} with fewer
    components
}
\description{
Adds several components of a composition together into a single
component
}
\examples{
data(Namib)
HMcomponents <- c("zr","tm","rt","TiOx","sph","ap","ep",
                  "gt","st","amp","cpx","opx")
am <- amalgamate(Namib$PTHM,feldspars=c("KF","P"),
                 lithics=c("Lm","Lv","Ls"),heavies=HMcomponents)
plot(ternary(am))
}
