% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternary.R
\name{ternary.ellipse}
\alias{ternary.ellipse}
\alias{ternary.ellipse.default}
\alias{ternary.ellipse.compositional}
\alias{ternary.ellipse.counts}
\title{Ternary confidence ellipse}
\usage{
ternary.ellipse(x, ...)

\method{ternary.ellipse}{default}(x, alpha = 0.05, population = TRUE,
  ...)

\method{ternary.ellipse}{compositional}(x, alpha = 0.05,
  population = TRUE, ...)

\method{ternary.ellipse}{counts}(x, alpha = 0.05, population = TRUE,
  ...)
}
\arguments{
\item{x}{an object of class \code{ternary}}

\item{...}{optional formatting arguments}

\item{alpha}{cutoff level for the confidence ellipse}

\item{population}{show the standard deviation of the entire
population or the standard error of the mean?}
}
\description{
plot a \eqn{100(1-\alpha)\%} confidence region around the data or
    around its mean.
}
\examples{
data(Namib)
tern <- ternary(Namib$Major,'CaO','Na2O','K2O')
plot(tern)
ternary.ellipse(tern)
}
