% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternary.R
\name{ternary}
\alias{ternary}
\title{Define a ternary composition}
\usage{
ternary(X, x = 1, y = 2, z = 3)
}
\arguments{
\item{X}{an object of class \code{compositional} OR a matrix or
data frame with numerical data}

\item{x}{string/number or a vector of strings/numbers indicating the
variables/indices making up the first subcomposition of the ternary system.}

\item{y}{second (set of) variables}

\item{z}{third (set of) variables}
}
\value{
an object of class \code{ternary}, i.e. a list containing:

x: a three column matrix (or vector) of ternary compositions.

and (if X is of class \code{SRDcorrected})

restoration: a list of intermediate ternary compositions inherited
from the SRD correction
}
\description{
Create an object of class \code{ternary}
}
\examples{
data(Namib)
tern <- ternary(Namib$PT,c('Q'),c('KF','P'),c('Lm','Lv','Ls'))
plot(tern,type="QFL")
}
\seealso{
restore
}
