% Generated by roxygen2 (4.0.1): do not edit by hand
\name{method_from_call}
\alias{method_from_call}
\title{Given a function class, find correspoding S4 method}
\usage{
method_from_call(call, env = parent.frame())
}
\arguments{
\item{call}{unquoted function call}

\item{env}{environment in which to look for function definition}
}
\description{
Given a function class, find correspoding S4 method
}
\examples{
library(stats4)

# From example(mle)
y <- c(26, 17, 13, 12, 20, 5, 9, 8, 5, 4, 8)
nLL <- function(lambda) -sum(dpois(y, lambda, log = TRUE))
fit <- mle(nLL, start = list(lambda = 5), nobs = length(y))

method_from_call(summary(fit))
method_from_call(coef(fit))
method_from_call(length(fit))
}

