% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_ppid}
\alias{ps_ppid}
\alias{ps_parent}
\title{Parent pid or parent process of a process}
\usage{
ps_ppid(p)

ps_parent(p)
}
\arguments{
\item{p}{Process handle.}
}
\value{
\code{ps_ppid()} returns and integer scalar, the pid of the parent
of \code{p}. \code{ps_parent()} returns a \code{ps_handle}.
}
\description{
\code{ps_ppid()} returns the parent pid, \code{ps_parent()} returns a \code{ps_handle}
of the parent.
}
\details{
On POSIX systems, if the parent process terminates, another process
(typically the pid 1 process) is marked as parent. \code{ps_ppid()} and
\code{ps_parent()} will return this process then.

Both \code{ps_ppid()} and \code{ps_parent()} work for zombie processes.
}
\seealso{
Other process handle functions: \code{\link{ps_children}},
  \code{\link{ps_cmdline}}, \code{\link{ps_cpu_times}},
  \code{\link{ps_create_time}}, \code{\link{ps_cwd}},
  \code{\link{ps_environ}}, \code{\link{ps_exe}},
  \code{\link{ps_handle}}, \code{\link{ps_is_running}},
  \code{\link{ps_kill}}, \code{\link{ps_memory_info}},
  \code{\link{ps_name}}, \code{\link{ps_num_threads}},
  \code{\link{ps_pid}}, \code{\link{ps_resume}},
  \code{\link{ps_send_signal}}, \code{\link{ps_status}},
  \code{\link{ps_suspend}}, \code{\link{ps_terminal}},
  \code{\link{ps_terminate}}, \code{\link{ps_uids}},
  \code{\link{ps_username}}

Other process handle functions: \code{\link{ps_children}},
  \code{\link{ps_cmdline}}, \code{\link{ps_cpu_times}},
  \code{\link{ps_create_time}}, \code{\link{ps_cwd}},
  \code{\link{ps_environ}}, \code{\link{ps_exe}},
  \code{\link{ps_handle}}, \code{\link{ps_is_running}},
  \code{\link{ps_kill}}, \code{\link{ps_memory_info}},
  \code{\link{ps_name}}, \code{\link{ps_num_threads}},
  \code{\link{ps_pid}}, \code{\link{ps_resume}},
  \code{\link{ps_send_signal}}, \code{\link{ps_status}},
  \code{\link{ps_suspend}}, \code{\link{ps_terminal}},
  \code{\link{ps_terminate}}, \code{\link{ps_uids}},
  \code{\link{ps_username}}
}
\section{Examples}{
\Sexpr[stage=install,strip.white=FALSE,results=rd]{ps:::decorate_examples('
p <- ps_handle()
p
ps_ppid(p)
ps_parent(p)
')}
}
