% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_covariate_list.R
\name{sim_covariate_list}
\alias{sim_covariate_list}
\title{Input covariate adjustment details for a simulation study}
\usage{
sim_covariate_list(covariate_list)
}
\arguments{
\item{covariate_list}{named list of objects of class \code{Covariate} created
by \code{add_covariates()}.}
}
\value{
Object of class \code{\link[=SimCovariateList-class]{SimCovariateList}}.
}
\description{
A function for defining which covariate adjustment scenarios should be evaluated as
part of a simulation study.
}
\details{
This function allows the user to specify covariate adjustment details that will be included
as part of a simulation study. It is often of interest to compare several adjustment methods to
no adjustment. To specify no adjustment, pass \code{NULL} as a list item to \code{covariate_list}.
}
\examples{

covariates <- sim_covariate_list(
  list(
    "No adjustment" = NULL,
    "Covariates 1 and 2" = add_covariates(c("cov1", "cov2"), prior_normal(0, 1000))
  )
)

}
\seealso{
Other simulation classes: 
\code{\link{sim_borrowing_list}()},
\code{\link{sim_data_list}()},
\code{\link{sim_outcome_list}()},
\code{\link{sim_treatment_list}()}
}
\concept{simulation classes}
