# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title c++ implementation of constrain filter
#' @param tapvec,maxslope see \code{\link{ctap_simple}}
#' @export
rcpp_ctap_simple <- function(tapvec, maxslope = 1L) {
    .Call('psd_rcpp_ctap_simple', PACKAGE = 'psd', tapvec, maxslope)
}

#' @title Nearest value below
#' @export
#' @description 
#' Returns the nearest \code{m}-length value (downwards from \code{n}).
#' @details
#' This function is different from \code{\link{nextn}} in that the value is floored.
#' For example:
#' \code{10} is the result for \code{n=11,m=2} whereas \code{\link{nextn}} would give \code{12}.
#' 
#' @param n integer; the number of terms (can be a vector)
#' @param m integer; the modulo term (cannot be zero)
#' 
#' @author A.J. Barbour
#' 
#' @seealso \code{\link{psd-utilities}}; \code{\link{psdcore}} uses this to 
#' truncate series to their nearest even length (i.e., \code{m=2}).
#' 
#' @examples
#' n <- 11
#' nextn(n) # 12
#' modulo_floor(n) # 10
#' 
#' # works on vectors too:
#' # defaults to m=2
#' modulo_floor(seq_len(n))
#' #[1]  0  2  2  4  4  6  6  8  8 10 10
#' 
#' # change the floor factor
#' modulo_floor(seq_len(n), 3)
#' #[1] 0 0 3 3 3 6 6 6 9 9 9
#' 
#' # zeros are not allowed for m
#' try(modulo_floor(n, 0))
#' 
modulo_floor <- function(n, m = 2L) {
    .Call('psd_modulo_floor', PACKAGE = 'psd', n, m)
}

#' @rdname parabolic_weights
#' @export
parabolic_weights_rcpp <- function(ntap = 1L) {
    .Call('psd_parabolic_weights_rcpp', PACKAGE = 'psd', ntap)
}

#' @title Resample an fft using varying numbers of sine tapers
#' 
#' @description
#' Produce an un-normalized psd based on an fft and a vector of optimal sine tapers
#' 
#' @details
#' To produce a psd estimate with our adaptive spectrum estimation method, we need only make one 
#' fft calculation initially and then
#' apply the weighting factors given by \code{\link{parabolic_weights_rcpp}}, which this
#' function does.
#' 
#' @param fftz complex; a vector representing the dual-length \code{\link{fft}}; see also the \code{dbl} argument
#' @param tapers integer; a vector of tapers
#' @param verbose logical; should messages be given?
#' @param dbl logical; should the code assume \code{fftz} is dual-length or single-length?
#' @param tapcap integer; the maximum number of tapers which can be applied; note that the length is
#' automatically limited by the length of the series.
#' 
#' @seealso \code{\link{riedsid}}
#' 
#' @examples
#' fftz <- complex(real=1:8, imaginary = 1:8)
#' taps <- 1:4
#' try(resample_fft_rcpp(fftz, taps))
#' 
#' @export
resample_fft_rcpp <- function(fftz, tapers, verbose = TRUE, dbl = TRUE, tapcap = 1000L) {
    .Call('psd_resample_fft_rcpp', PACKAGE = 'psd', fftz, tapers, verbose, dbl, tapcap)
}

