% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hettmansperger.R
\name{hettmansperger_norton_test_internal}
\alias{hettmansperger_norton_test_internal}
\title{Hettmansperger-Norton Trend Test for k-Samples}
\usage{
hettmansperger_norton_test_internal(data, group, na.rm,
  alternative = c("decreasing", "increasing", "custom"), formula = NULL,
  trend = NULL, pseudoranks = TRUE, ...)
}
\arguments{
\item{data}{numeric vector containing the data}

\item{group}{ordered factor vector for the groups}

\item{na.rm}{a logical value indicating if NA values should be removed}

\item{alternative}{either decreasing or increasing}

\item{formula}{formula object}

\item{trend}{custom numeric vector indicating the trend for the custom alternative, only used if alternative = "custom"}

\item{...}{further arguments are ignored}
}
\value{
Returns a data.frame with the results
}
\description{
This function calculates the Hettmansperger-Norton trend test using pseudo-ranks under the null hypothesis H0F: F_1 = ... F_k.
}
\examples{
# create some data, please note that the group factor needs to be ordered
df <- data.frame(data = c(rnorm(40, 3, 1), rnorm(40, 2, 1), rnorm(20, 1, 1)),
  group = c(rep(1,40),rep(2,40),rep(3,20)))
df$group <- factor(df$group, ordered = TRUE)

# you can either test for a decreasing, increasing or custom trend
hettmansperger_norton_test(df$data, df$group, alternative="decreasing")
hettmansperger_norton_test(df$data, df$group, alternative="increasing")
hettmansperger_norton_test(df$data, df$group, alternative="custom", trend = c(1, 3, 2))
}
\references{
Brunner, E., Bathke, A.C., and Konietschke, F. (2018a). Rank- and Pseudo-Rank Procedures for Independent Observations in Factorial Designs - Using R and SAS. Springer Series in Statistics, Springer, Heidelberg. ISBN: 978-3-030-02912-8.

Hettmansperger, T. P., & Norton, R. M. (1987). Tests for patterned alternatives in k-sample problems. Journal of the American Statistical Association, 82(397), 292-299
}
\keyword{internal}
