% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{calc_risk}
\alias{calc_risk}
\title{Calculate the risk and functions of the risk}
\usage{
calc_risk(psdesign, contrast = "VE", t, sig.level = 0.05,
  CI.type = "band", n.samps = 5000, bootstraps = TRUE, newdata = NULL)
}
\arguments{
\item{psdesign}{A psdesign object. It must contain a risk model, an
integration model, and estimated parameters. Bootstrapped parameters are
optional}

\item{contrast}{The contrast function, or the name of the contrast function.
See details.}

\item{t}{For time to event outcomes, a fixed time \code{t} may be provided to
compute the cumulative distribution function. If not, the restricted mean
survival time is used. Omit for binary outcomes.}

\item{sig.level}{Significance level for bootstrap confidence intervals}

\item{CI.type}{Character string, "pointwise" for pointwise confidence
intervals, and "band" for simultaneous confidence band.}

\item{n.samps}{The number of samples to take over the range of S.1 at which
the VE is calculated}

\item{bootstraps}{If true, and bootstrapped estimates are present, will
calculate bootstrap standard errors and confidence bands.}

\item{newdata}{Vector of S values. If present, will calculate the contrast
function at values of newdata instead of the observed S.1}
}
\value{
A data frame containing columns for the S values, the computed
  contrast function at S, R0, and R1 at those S values, and optionally
  standard errors and confidence intervals computed using bootstrapped
  estimates.
}
\description{
Computes the vaccince efficacy (VE) and other functions of the risk in each
treatment arm over the range of surrogate values observed in the data. VE(s)
is defined as 1 - risk(s, z = 1)/risk(s, z = 0), where z is the treatment
indicator. If any other variables are present in the risk model, then the
risk is computed at their median value.
}
\details{
The contrast function is a function that takes 2 inputs, the risk_0
  and risk_1, and returns some one dimensional function of those two inputs.
  It must be vectorized. Some built-in functions are \code{"VE"} for vaccine
  efficacy = 1 - risk_1(s)/risk_0(s), \code{"RR"} for relative risk =
  risk_1(s)/risk_0(s), \code{"logRR"} for log of the relative risk, and
  \code{"RD"} for the risk difference = risk_1(s) - risk_0(s).
}
\examples{
\dontrun{
# same result passing function name or function
calc_risk(binary.boot, contrast = "VE", n.samps = 20)
calc_risk(binary.boot, contrast = function(R0, R1) 1 - R1/R0, n.samps = 20)
}
}

