% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SWC,MDC.R
\name{SWC}
\alias{SWC}
\title{Smallest Worthwhile Change (SWC) for a set of athlete measurements}
\usage{
SWC(subject, trial, ..., effect_size = 0.2, method = c("AVG", "MAX", "MIN"))
}
\arguments{
\item{subject}{The vector of athletes who recorded the results for each metric (can be a numeric or factor variable)}

\item{trial}{The vector that represents which trial each measurement came from}

\item{...}{Numeric vectors that represent the metrics for which the SWC should be computed. These vectors hold the scores that
each athlete recorded for each respective metric (at least one metric must be passed to the function).}

\item{effect_size}{The proportion of the within-subject standard deviation that is defined as a worthwhile change. The default
value is 0.2, but users can input any positive value into this argument.}

\item{method}{The user's choice of how the between-athlete SD should be computed in the formula for the SWC. If set to AVG, each
athlete's values will be averaged before the SD of these between-athlete averages is computed. If MAX is selected, then only
the highest value each athlete records will be included in the computation of the between-athlete SD. Conversely, if the user
indicates MIN, then only the lowest value each athlete records will be used to compute the between-athlete SD.}
}
\value{
A data frame, with the name of each metric situated above its calculated SWC
}
\description{
Computes the SWC for each vector of measurements that is passed to the function, for the subject and trial vectors,
  the desired effect size of the change, and the desired method of calculating the between-subject standard deviation
}
\examples{
subject <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
trial <- c(1, 2, 3, 1, 2, 3, 1, 2, 3)
metric_1 <- c(250, 258, 252, 279, 270, 277, 218, 213, 218)
metric_2 <- c(10, 7, 10, 14, 18, 17, 11, 7, 8)
metric_3 <- c(1214, 1276, 1289, 1037, 1010, 1069, 1481, 1465, 1443)
SWC(subject, trial, metric_1, metric_2, metric_3, effect_size = 0.2, method = 'AVG')

}
\references{
Bernards, J., Sato, K., Haff, G., & Bazyler, C. (2017). Current Research and Statistical Practices in Sport
  Science and a Need for Change. Sports, 5(4), 87.
}
