% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_ps.R
\name{rwe_ps_borrow}
\alias{rwe_ps_borrow}
\title{Get number of subjects borrowed from each statum}
\usage{
rwe_ps_borrow(total_borrow, dta_ps_dist, ...)
}
\arguments{
\item{total_borrow}{Total number of subjects to be borrowed}

\item{dta_ps_dist}{A class \code{RWE_PSDIST}}

\item{...}{Other options}
}
\value{
A vector of number of subjects to be borrowed from each stratum
}
\description{
Based on PS distances, split the total number of subjects to be borrowed from
the external data source to each stratum
}
\examples{

dta_ps <- rwe_ps(ex_dta,
                 v_covs = paste("V", 1:7, sep = ""),
                 v_grp = "Group",
                 cur_grp_level = "current")

ps_dist <- rwe_ps_dist(dta_ps, metric = "ovl")
ps_borrow <- rwe_ps_borrow(total_borrow = 100, ps_dist)

}
