% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composites.R
\name{composite_d_matrix}
\alias{composite_d_matrix}
\title{Matrix formula to estimate the standardized mean difference associated with a weighted or unweighted composite variable}
\usage{
composite_d_matrix(d_vec, r_mat, wt_vec, p = 0.5)
}
\arguments{
\item{d_vec}{Vector of standardized mean differences associated with variables in the composite to be formed.}

\item{r_mat}{Correlation matrix from which the composite is to be computed.}

\item{wt_vec}{Weights to be used in forming the composite (by default, all variables receive equal weight).}

\item{p}{The proportion of cases in one of the two groups used the compute the standardized mean differences.}
}
\value{
The estimated standardized mean difference associated with the composite variable.
}
\description{
This function is a wrapper for \code{\link{composite_r_matrix}} that converts \emph{d} values to correlations, computes the composite correlation implied by the \emph{d} values, and transforms the result back to the \emph{d} metric.
}
\details{
The composite \emph{d} value is computed by converting the vector of \emph{d} values to correlations, computing the composite correlation (see \code{composite_r_matrix}), and transforming that composite back into the \emph{d} metric.
See "Details" of \code{\link{composite_r_matrix}} for the composite computations.
}
\examples{
composite_d_matrix(d_vec = c(1, 1), r_mat = matrix(c(1, .7, .7, 1), 2, 2),
wt_vec = c(1, 1), p = .5)
}
