% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{screen_ad_int}
\alias{screen_ad_int}
\title{Screen to detect invalid interactive artifact distribution objects}
\usage{
screen_ad_int(x)
}
\arguments{
\item{x}{Object to test for congruence with expected properties of interactive artifact distribution objects.}
}
\value{
Does not return a value; will trigger a warning if ad_obj_tsa is not a valid artifact distribution.
}
\description{
Screen to detect invalid interactive artifact distribution objects
}
\examples{
\dontrun{
ad_obj_int <- create_ad_int(rxxa = c(.9, .8), wt_rxxa = c(50, 150),
                            rxxi = c(.8, .7), wt_rxxi = c(50, 150),
                            ux = c(.9, .8), wt_ux = c(50, 150),
                            ut = c(.8, .7), wt_ut = c(50, 150))

ad_obj_tsa <- create_ad_tsa(rxxa = c(.9, .8), n_rxxa = c(50, 150),
                            rxxi = c(.8, .7), n_rxxi = c(50, 150),
                            ux = c(.9, .8), ni_ux = c(50, 150),
                            ut = c(.8, .7), ni_ut = c(50, 150))

screen_ad_int(x = ad_obj_int)
screen_ad_int(x = ad_obj_tsa)
screen_ad_int(x = data.frame(Value = 1, Weight = 1))
}
}
\keyword{internal}
