% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetStationPressure}
\alias{GetStationPressure}
\title{Return station pressure from sea level pressure.}
\usage{
GetStationPressure(SeaLevelPressure, Altitude, TDryBulb)
}
\arguments{
\item{SeaLevelPressure}{A numeric vector of sea level barometric pressure in Psi [IP] or Pa [SI]}

\item{Altitude}{A numeric vector of altitude in ft [IP] or m [SI]}

\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}
}
\value{
A numeric vector of station pressure in Psi [IP] or Pa [SI]
}
\description{
Return station pressure from sea level pressure.
}
\note{
This function is just the inverse of \code{\link{GetSeaLevelPressure}}.
}
\examples{
SetUnitSystem("IP")
GetStationPressure(14.68, 300:400, 62.94)

SetUnitSystem("SI")
GetStationPressure(101226.5, 105:205, 17.19)

}
\references{
See \code{\link{GetSeaLevelPressure}}.
}
