% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetHumRatioFromTDewPoint}
\alias{GetHumRatioFromTDewPoint}
\title{Return humidity ratio given dew-point temperature and pressure.}
\usage{
GetHumRatioFromTDewPoint(TDewPoint, Pressure)
}
\arguments{
\item{TDewPoint}{A numeric vector of dew-point temperature in degreeF [IP] or degreeC [SI]}

\item{Pressure}{A numeric vector of atmospheric Pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of humidity ratio in lb_H2O lb_Air-1 [IP] or kg_H2O kg_Air-1 [SI]
}
\description{
Return humidity ratio given dew-point temperature and pressure.
}
\examples{
SetUnitSystem("IP")
GetHumRatioFromTDewPoint(50:80, 14.175)

SetUnitSystem("SI")
GetHumRatioFromTDewPoint(20:30, 95461.0)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 13
}
