% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetMoistAirEnthalpy}
\alias{GetMoistAirEnthalpy}
\title{Return moist air enthalpy given dry-bulb temperature and humidity ratio.}
\usage{
GetMoistAirEnthalpy(TDryBulb, HumRatio)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{HumRatio}{A numeric vector of humidity ratio in lb_H2O lb_Air-1 [IP] or kg_H2O kg_Air-1 [SI]}
}
\value{
A numeric vector of moist air enthalpy in Btu lb-1 [IP] or J kg-1
}
\description{
Return moist air enthalpy given dry-bulb temperature and humidity ratio.
}
\examples{
SetUnitSystem("IP")
GetMoistAirEnthalpy(80:100, 0.02)

SetUnitSystem("SI")
GetMoistAirEnthalpy(20:30, 0.02)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 30
}
