% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getseq.R
\name{prot2codon}
\alias{prot2codon}
\title{Find the Coding Triplets for a Given Protein}
\usage{
prot2codon(prot, chain = "", laxity = TRUE)
}
\arguments{
\item{prot}{is either a UniProt or PDB id, or the path to a pdb file.}

\item{chain}{when prot corresponds to a pdb, the chain of interest must be provided.}

\item{laxity}{logical, if FALSE the program stop when a mismatch between the protein and the gene sequences is detected. Otherwise the program doesn't stop and at the end points out the mismatches.}
}
\value{
Returns a dataframe with as many rows as residues has the protein.
}
\description{
Finds the codons corresponding to a given protein.
}
\examples{
\dontrun{prot2codon('P01009')}
}
\author{
Juan Carlos Aledo
}
