% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-ptglmm.R
\name{summary.ptglmm}
\alias{summary.ptglmm}
\title{Summarizing Poisson-Tweedie and negative binomial mixed model estimation results}
\usage{
\method{summary}{ptglmm}(object, wald = T, ...)
}
\arguments{
\item{object}{an object of class \code{ptglmm} (obtained 
from \code{ptmixed} or \code{nbmixed}).}

\item{wald}{logical. If \code{TRUE}, standard errors and univariate Wald test are computed. Default is \code{TRUE}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A list with the following elements: value of the loglikelihood at the MLE (\code{logl}),
table with maximum likelihood estimates of the regression coefficients, SEs and Wald tests \code{coefficients}, 
and maximum likelihood estimates of the other parameters (\code{D}, \code{a} and \code{sigma2})
}
\description{
Provides parameter estimates, standard errors and univariate Wald test
for the Poisson-Tweedie and negative binomial generalized
linear mixed models (fitted through \code{ptmixed} and 
\code{nbmixed} respectively)
}
\seealso{
\code{\link{ptmixed}}, \code{\link{nbmixed}} and the examples therein
}
\author{
Mirko Signorelli
}
