% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{generate_all_estimates}
\alias{generate_all_estimates}
\title{Obtain estimates for Parameters of Pareto Data from all methods}
\usage{
generate_all_estimates(dat)
}
\arguments{
\item{dat}{vector of observations}
}
\value{
Dataframe with the following columns:
\describe{
  \item{Method.of.Estimation}{Name of the method used for estimation}
  \item{Shape.Parameter}{Estimates of the shape parameter of the data}
  \item{Scale.Parameter}{Estimates of the scale parameter of the data}
}
}
\description{
This function combines the results of all the methods (included in this
package) provided to estimate the \code{shape} and \code{scale} parameters 
of the Pareto data and provides the results in a data frame. Hill's 
Estimator is not used in this comparison as it discards a set of 
observations. We also note here that when considering the entire data set, 
Hill's Estimate is equivalent to the MLE.
}
\examples{
x <- generate_pareto(10000, 5, 2)
generate_all_estimates(x)

}
