% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Roberts}
\alias{Roberts}
\title{Extracorporeal membrane oxygenation in neonates.}
\format{
A labelled tibble with 185 rows and 2 variables:
\describe{
\item{emo}{Extracorporeal membrane oxygenation treatment, factor with levels "No" and "Yes".}
\item{survived}{One year survival, factor with levels "No" and "Yes".}
}
}
\source{
Roberts, TE (1998) Extracorporeal Membrane Oxygenation Economics Working Group. Economic
evaluation and randomised controlled trial of extracorporeal membrane oxygenation: UK collaborative
trial. Brit Med J 317:911-16.
}
\usage{
Roberts
}
\description{
A clinical trial on the value of extracorporeal membrane oxygenation for term neonates with severe
respiratory failure. RCT compares active treatment against conventional management.
}
\examples{
data(Roberts)

Roberts \%>\%
  cross_tab(survived ~ emo)
}
\keyword{datasets}
