% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\docType{data}
\name{pp_opts}
\alias{pp_opts}
\title{General options for the pubprint package}
\format{A list with a \code{get} and \code{set} function.}
\usage{
pp_opts
}
\description{
Options including how many decimal places are used, whether to remove items
when pulling them, etc.
}
\details{
Set global options with \code{pp_opts$set()} and get your options with
\code{pp_opts$get()}.
\describe{
  \item{\code{nsmall}:}{controls the number of digits to print when printing
    numeric values.}
  \item{\code{delimiter}:}{delimiter between items.}
  \item{\code{removeItems}:}{controls whether items are removed when pulling
    them. Either a logical, \code{"memory"} or \code{"pipe"}. See
    \code{\link{pull.pubprint} for more details.}}
  \item{\code{mmode}:}{controls whether output is set in math mode.}
  \item{\code{brackets}:}{controls which brackets are used.}
  \item{\code{separator}:}{controls whether a separator between content and
    pubprint output is printed.}
}
}
\examples{
pp_opts$set(nsmall = 3)
pp_opts$set(nsmall = 3, removeItems = FALSE)
pp_opts$get("nsmall")
pp_opts$get()

}
\keyword{datasets}

