% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_topology.R
\name{plot_topology}
\alias{plot_topology}
\title{Plot the topology}
\usage{
plot_topology(topology)
}
\arguments{
\item{topology}{the topology as a \link[tibble]{tibble}
as returned by \link{predict_topology}}
}
\value{
a \link[ggplot2]{ggplot} that displays the topology of
one or more proteins
}
\description{
Plot the topology
}
\examples{
if (is_pureseqtm_installed() && is_on_ci()) {
  fasta_filename <- get_example_filename("test_proteome.fasta")
  topology <- predict_topology(fasta_filename)
  plot_topology(topology)
}
}
\author{
Richèl J.C. Bilderbeek
}
