% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{ped_rename}
\alias{ped_rename}
\title{Rename individuals in a pedigree from 1 to N}
\usage{
ped_rename(ped, id = "id", dam = "dam", sire = "sire", keep_names = FALSE)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{id}{A string naming the column with individual identities. It will be renamed to its default value 'id'.}

\item{dam}{A string naming the column with maternal identities. It will be renamed to its default value 'dam'.}

\item{sire}{A string naming the column with paternal identities. It will be renamed to its default value 'sire'.}

\item{keep_names}{A boolean value indicating whether the original identity values should be kept on a separate column (named 'names'), or not.}
}
\value{
A dataframe with the pedigree's identities renamed.
}
\description{
Functions in \bold{purgeR} require individuals to be named with integers from 1 to N.
This takes a dataframe containing a pedigree, and rename individuals having
names in any format to that required by other functions in \pkg{purgeR}. The
process will also check that the pedigree format is suitable for other functions
in the package.
}
\examples{
data(darwin)
darwin <- ped_rename(darwin, id = "Individual", dam = "Mother", sire = "Father", keep_names = TRUE)
head(darwin)
}
\seealso{
\code{\link{ped_clean}}
}
