% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Chi2x2.R
\name{Chi2x2}
\alias{Chi2x2}
\title{Compute power for an Chi Square 2x2
Takes proportions for each group. Alpha is .05 by default, alternative values may be entered by user}
\usage{
Chi2x2(r1c1, r1c2, r2c1, r2c2, n, alpha = 0.05)
}
\arguments{
\item{r1c1}{Proportion of overall scores in Row 1, Column 1}

\item{r1c2}{Proportion of overall scores in Row 1, Column 2}

\item{r2c1}{Proportion of overall scores in Row 2, Column 1}

\item{r2c2}{Proportion of overall scores in Row 2, Column 2}

\item{n}{Total sample size}

\item{alpha}{Type I error (default is .05)}
}
\value{
Power for 2x2 Chi Square
}
\description{
Compute power for an Chi Square 2x2
Takes proportions for each group. Alpha is .05 by default, alternative values may be entered by user
}
\examples{
Chi2x2(r1c1=.28,r1c2=.22,r2c1=.38,r2c2=.12,n=100)
}
