% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova1f_4.R
\name{anova1f_4}
\alias{anova1f_4}
\title{Compute power for a One Factor Between Subjects ANOVA with four levels
Takes means, sds, and sample sizes for each group}
\usage{
anova1f_4(
  m1 = NULL,
  m2 = NULL,
  m3 = NULL,
  m4 = NULL,
  s1 = NULL,
  s2 = NULL,
  s3 = NULL,
  s4 = NULL,
  n1 = NULL,
  n2 = NULL,
  n3 = NULL,
  n4 = NULL,
  alpha = 0.05
)
}
\arguments{
\item{m1}{Mean of first group}

\item{m2}{Mean of second group}

\item{m3}{Mean of third group}

\item{m4}{Mean of fourth group}

\item{s1}{Standard deviation of first group}

\item{s2}{Standard deviation of second group}

\item{s3}{Standard deviation of third group}

\item{s4}{Standard deviation of forth group}

\item{n1}{Sample size for first group}

\item{n2}{Sample size for second group}

\item{n3}{Sample size for third group}

\item{n4}{Sample size for fourth group}

\item{alpha}{Type I error (default is .05)}
}
\value{
Power for the One Factor Between Subjects ANOVA
}
\description{
Compute power for a One Factor Between Subjects ANOVA with four levels
Takes means, sds, and sample sizes for each group
}
\examples{
anova1f_4(m1=80, m2=82, m3=82, m4=86, s1=10, s2=10, s3=10,
s4=10, n1=60, n2=60, n3=60, n4=60)
}
