% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_prec.R
\name{d_prec}
\alias{d_prec}
\title{Compute Precision Analyses for Standardized Mean Differences}
\usage{
d_prec(d, nlow, nhigh, propn1 = 0.5, ci = 0.95, tails = 2, by = 1)
}
\arguments{
\item{d}{Standardized means difference between groups}

\item{nlow}{starting total sample size}

\item{nhigh}{ending total sample size}

\item{propn1}{Proportion in First Group}

\item{ci}{Type of Confidence Interval (e.g., .95)}

\item{tails}{number of tails for test (default is 2)}

\item{by}{Incremental increase in sample (e.g. nlow = 10, nhigh = 24, by = 2, produces estimates of 10, 12, and 14)}
}
\value{
Precision Analyses for Standardized Mean Differences
}
\description{
Compute Precision Analyses for Standardized Mean Differences
}
\examples{
d_prec(d=.4,nlow=100, nhigh=2000, propn1=.5, ci=.95, by=100)
}
