% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anc.R
\name{anc}
\alias{anc}
\title{Compute Power for One or Two Factor ANCOVA with a single covariate
Takes means, sds, and sample sizes for each group. Alpha is .05 by default, alternative values may be entered by user
Factor A can have up to four levels, Factor B, if used, can only be two}
\usage{
anc(
  m1.1,
  m2.1,
  m1.2,
  m2.2,
  m3.1 = NULL,
  m3.2 = NULL,
  m4.1 = NULL,
  m4.2 = NULL,
  s1.1 = NULL,
  s2.1 = NULL,
  s1.2 = NULL,
  s2.2 = NULL,
  s3.1 = NULL,
  s3.2 = NULL,
  s4.1 = NULL,
  s4.2 = NULL,
  r,
  s = NULL,
  alpha = 0.05,
  factors,
  levelsA = NULL,
  n
)
}
\arguments{
\item{m1.1}{Cell mean for First level of Factor A, First level of Factor B}

\item{m2.1}{Cell mean for Second level of Factor A, First level of Factor B}

\item{m1.2}{Cell mean for First level of Factor A, Second level of Factor B}

\item{m2.2}{Cell mean for Second level of Factor A, Second level of Factor B}

\item{m3.1}{Cell mean for Third level of Factor A, First level of Factor B}

\item{m3.2}{Cell mean for Third level of Factor A, Second level of Factor B}

\item{m4.1}{Cell mean for Fourth level of Factor A, First level of Factor B}

\item{m4.2}{Cell mean for Fourth level of Factor A, Second level of Factor B}

\item{s1.1}{Cell standard deviation for First level of Factor A, First level of Factor B}

\item{s2.1}{Cell standard deviation for Second level of Factor A, First level of Factor B}

\item{s1.2}{Cell standard deviation for First level of Factor A, Second level of Factor B}

\item{s2.2}{Cell standard deviation for Second level of Factor A, Second level of Factor B}

\item{s3.1}{Cell standard deviation for Third level of Factor A, First level of Factor B}

\item{s3.2}{Cell standard deviation for Third level of Factor A, Second level of Factor B}

\item{s4.1}{Cell standard deviation for Fourth level of Factor A, First level of Factor B}

\item{s4.2}{Cell standard deviation for Fourth level of Factor A, Second level of Factor B}

\item{r}{Correlation between covariate and dependent variable.}

\item{s}{Overall standard deviation. Sets all cell sds equal}

\item{alpha}{Type I error (default is .05)}

\item{factors}{Number of factors (1 or 2)}

\item{levelsA}{levels for factor A (up to four)}

\item{n}{Sample Size per cell}
}
\value{
Power for One or Two Factor ANCOVA with a single covariate
}
\description{
Compute Power for One or Two Factor ANCOVA with a single covariate
Takes means, sds, and sample sizes for each group. Alpha is .05 by default, alternative values may be entered by user
Factor A can have up to four levels, Factor B, if used, can only be two
}
\examples{
anc(m1.1=.85,m2.1=2.5, s1.1 = 1.7, s2.1=1,
m1.2=0.85, m2.2= 2.5, s1.2 = 1.7, s2.2=1,
m3.1=0.0,m3.2=2.5, s3.1 = 1.7, s3.2=1,
m4.1=0.6, m4.2 = 2.5, s4.1 = 1.7, s4.2=1, r= 0.4,
n=251, factors =2,levelsA = 4)
}
