% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_variable2.R
\name{px_elimination}
\alias{px_elimination}
\alias{px_elimination.px}
\title{ELIMINATION}
\usage{
px_elimination(x, value, validate)

\method{px_elimination}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. A character string or data frame.
\itemize{
\item Use character to set ELIMINATION for all languages and STUB/HEADING
variables.
\item Use data frame with columns 'variable-code', 'language' and
'elimination' to set ELIMINATION for specific variables.
\item If missing, the current ELIMINATION is returned.
\item If NULL, ELIMINATION is removed for all variables.
}}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object, a character string, or a data frame.
}
\description{
Inspect or change ELIMINATION.
}
\examples{
# Set ELIMINATION for all languages
x1 <-
  px(population_gl) |>
  px_elimination('YES')

# Print ELIMINATION
px_elimination(x1)

# Set ELIMINATION for individual variables
library(tibble)
x2 <-
  x1 |>
  px_elimination(tribble(~`variable-code`, ~elimination,
                    'gender', 'All',
                    'age',    'Total'))
px_elimination(x2)

# Set ELIMINATION for individual languages
x3 <-
  x2 \%>\%
  px_languages(c('en', 'kl')) |>
  px_elimination(tribble(~`variable-code`, ~language, ~elimination,
                    'gender',    'en',      'All_en',
                    'gender',    'kl',      'All_kl',
                    'age',       'en',      'Total_en'))
px_elimination(x3)

# Remove ELIMINATION
x4 <- px_elimination(x3, NULL)
px_elimination(x4)
}
\seealso{
\href{https://www.scb.se/globalassets/vara-tjanster/px-programmen/px-file_format_specification_2013.pdf#\%5B\%7B\%22num\%22\%3A46\%2C\%22gen\%22\%3A0\%7D\%2C\%7B\%22name\%22\%3A\%22XYZ\%22\%7D\%2C184\%2C525\%2C0\%5D}{Statistics Sweden's documentation}
}
