% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pxweb_query.R
\name{pxweb_query}
\alias{pxweb_query}
\alias{pxweb_query.character}
\alias{pxweb_query.json}
\alias{pxweb_query.pxweb_query}
\alias{pxweb_query.list}
\alias{pxweb_query.response}
\alias{pxweb_query.pxweb_explorer}
\title{Create a PXWEB query}
\usage{
pxweb_query(x)

\method{pxweb_query}{character}(x)

\method{pxweb_query}{json}(x)

\method{pxweb_query}{pxweb_query}(x)

\method{pxweb_query}{list}(x)

\method{pxweb_query}{response}(x)

\method{pxweb_query}{pxweb_explorer}(x)
}
\arguments{
\item{x}{an object to cast as a pxweb_query object.}
}
\description{
Creates a pxweb query object from either a list with named values, 
a json query file or json query string. See examples below.
}
\examples{
dims <- list(Alue = c("*"),
             "Asuntokunnan koko" = c("*"),
             Talotyyppi = c("S"),
             Vuosi = c("*"))
pxq1 <- pxweb_query(dims)

json_query <- file.path(system.file(package = "pxweb"), 
                        "extdata", "examples", "json_query_example.json")
pxq2 <- pxweb_query(json_query)


}
\seealso{
\code{\link{pxweb_query_as_json}}, \code{\link{pxweb_query_as_rcode}}
}
\keyword{internal}
