% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateNotification.R
\name{GenerateNotification}
\alias{GenerateNotification}
\title{Generate Notification}
\usage{
GenerateNotification(destination, transport = "Email", event.type,
  version = "2006-05-05")
}
\arguments{
\item{destination}{Currently, a character string containing a complete email
address (if \code{transport="Email"}), the SQS URL (if
\code{transport="SQS"}) or the SNS topic (if \code{transport="SNS"})}

\item{transport}{Only \dQuote{\code{Email}}, \dQuote{\code{SQS}}
and \dQuote{\code{SNS}} are supported. AWS recommends the use of the SQS
transport.}

\item{event.type}{A character string containing one of:
\code{AssignmentAccepted}, \code{AssignmentAbandoned}, \code{AssignmentReturned},
\code{AssignmentSubmitted}, \code{AssignmentRejected}, \code{AssignmentApproved},
\code{HITCreated}, \code{HITExtended}, \code{HITDisposed}, \code{HITReviewable},
\code{HITCreated}, \code{HITExtended}, \code{HITDisposed}, \code{HITReviewable},
\code{HITExpired} (the default), or \code{Ping}.}

\item{version}{Version of the HITType Notification API to use. Intended only
for advanced users.}
}
\value{
A dictionary object containing the Notification data structure.
}
\description{
Generate a HITType Notification data structure for use in
\code{\link{SetHITTypeNotification}}.
}
\details{
Generate a Notification data structure for use in the \code{notification}
option of \code{\link{SetHITTypeNotification}}.
}
\references{
\href{http://docs.amazonwebservices.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_NotificationDataStructureArticle.html}{API Reference}

\href{http://docs.amazonwebservices.com/AWSMechTurk/latest/AWSMechanicalTurkRequester/Concepts_NotificationsArticle.html}{API Reference: Concept}
}
\seealso{
\code{\link{SetHITTypeNotification}}

\code{\link{SendTestEventNotification}}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{Notifications}
