% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlockWorker.R
\name{BlockWorker}
\alias{BlockWorker}
\alias{BlockWorkers}
\alias{block}
\alias{CreateWorkerBlock}
\alias{UnblockWorker}
\alias{UnblockWorkers}
\alias{unblock}
\alias{DeleteWorkerBlock}
\alias{GetBlockedWorkers}
\alias{blockedworkers}
\alias{ListWorkerBlocks}
\alias{listworkerblocks}
\title{Block Worker(s)}
\usage{
BlockWorker(workers, reasons = NULL,
  verbose = getOption("pyMTurkR.verbose", TRUE))
}
\arguments{
\item{workers}{A character string containing a WorkerId, or a vector of
character strings containing multiple WorkerIds.}

\item{reasons}{A character string containing a reason for blocking a worker.
This must have length 1 or length equal to the number of workers.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
\code{BlockWorker} returns a data frame containing the list of workers,
reasons (for blocking them), and whether the request to block was valid.
}
\description{
Block a worker. This prevents a worker from completing any HITs
for you while they are blocked, but does not affect their ability to
complete work for other requesters or affect their worker statistics.
}
\details{
\code{BlockWorker} prevents the specified worker from completing any of your
HITs.

\code{BlockWorkers()}, \code{block()} and \code{CreateWorkerBlock()},
are aliases for \code{BlockWorker}. \code{UnblockWorkers()},
\code{unblock()}, and \code{DeleteWorkerBlock()} are aliases for
\code{UnblockWorker}. \code{blockedworkers()} is an alias for
\code{GetBlockedWorkers}.
}
\examples{

\dontrun{
BlockWorker("A1RO9UJNWXMU65", reasons="Did not follow HIT instructions.")
UnblockWorker("A1RO9UJNWXMU65")
}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateWorkerBlockOperation.html}{API Reference: Block}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{Workers}
