% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_startswith.R
\name{pystr_startswith}
\alias{pystr_startswith}
\title{Check the prefix of a string.}
\usage{
pystr_startswith(str, prefix, start = 1, end = nchar(str))
}
\arguments{
\item{str}{A character vector.}

\item{prefix}{A character vector.}

\item{start}{A numeric vector.}

\item{end}{A numeric vector.}
}
\value{
A logical vector.
}
\description{
Return \code{TRUE} if the string \code{str} starts with the specified
\code{prefix}, otherwise return \code{FALSE}.
}
\details{
With optional \code{start}, test string beginning at that position.
With optional \code{end}, stop comparing string at that position.
}
\examples{
pystr_startswith("www.example.com", "www.")
pystr_startswith("example.com", "www.")
pystr_startswith("www.example.com", "example", 5)
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.startswith}
}
\seealso{
\code{\link{pystr_endswith}}
}

