% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMARC.R
\name{predict.qCBARuleModel}
\alias{predict.qCBARuleModel}
\title{Aplies qCBARuleModel}
\usage{
\method{predict}{qCBARuleModel}(
  object,
  newdata,
  testingType,
  loglevel = "WARNING",
  outputFiringRuleIDs = FALSE,
  outputConfidenceScores = FALSE,
  confScoreType = "ordered",
  positiveClass = NULL,
  ...
)
}
\arguments{
\item{object}{\link{qCBARuleModel} class instance}

\item{newdata}{data frame with data}

\item{testingType}{either \code{mixture} for multi-rule classification or \code{firstRule} for one-rule classification. Applicable only when model is loaded from file.}

\item{loglevel}{logger level from \code{java.util.logging}}

\item{outputFiringRuleIDs}{if set to TRUE, instead of predictions, the function will return one-based IDs of  rules used to classify each instance (one rule per instance).}

\item{outputConfidenceScores}{if set to TRUE, instead of predictions, the function will return confidences of the firing rule}

\item{confScoreType}{applicable only if `outputConfidenceScores=TRUE`, possible values `ordered` for confidence computed only for training instances reaching this rule, or `global` for standard rule confidence computed from the complete training data}

\item{positiveClass}{This setting is only used if `outputConfidenceScores=TRUE`. It should be used only for binary problems. In this 
case, the confidence values are recalculated so that these are not confidence values of the predicted class (default behaviour of `outputConfidenceScores=TRUE`)
but rather confidence values associated with the class designated as positive}

\item{...}{other arguments (currently not used)}
}
\value{
vector with predictions.
}
\description{
Applies \link{qcba} rule model on provided data. 
Automatically detects whether one-rule or  multi-rule classification is used
}
\examples{
allData <- datasets::iris[sample(nrow(datasets::iris)),]
trainFold <- allData[1:100,]
testFold <- allData[101:nrow(datasets::iris),]
rmCBA <- cba(trainFold, classAtt="Species")
rmqCBA <- qcba(cbaRuleModel=rmCBA, datadf=trainFold)
print(rmqCBA@rules)
prediction <- predict(rmqCBA,testFold)
acc <- CBARuleModelAccuracy(prediction, testFold[[rmqCBA@classAtt]])
message(acc)
firingRuleIDs <- predict(rmqCBA,testFold,outputFiringRuleIDs=TRUE)
message("The second instance in testFold was classified by the following rule")
message(rmqCBA@rules[firingRuleIDs[2],1])
message("The second instance is")
message(testFold[2,])

}
\seealso{
\link{qcba}
}
