% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1.R
\name{D1}
\alias{D1}
\alias{D1.ECBC}
\alias{zeta1}
\title{Calculate the D1 distance between two dependence structures}
\usage{
D1(x1, y1, x2, y2, resolution = NULL)

D1.ECBC(A, B)

zeta1(X, Y, resolution = NULL)
}
\arguments{
\item{x1}{a (non-empty) numeric vector of data values for the first random vector (first coordinate)}

\item{y1}{a (non-empty) numeric vector of data values for the first random vector (second coordinate)}

\item{x2}{a (non-empty) numeric vector of data values for the second random vector (first coordinate)}

\item{y2}{a (non-empty) numeric vector of data values for the second random vector (second coordinate)}

\item{resolution}{integer indicating the resolution of the checkerboard copula. (default = NULL)}

\item{A}{Numeric matrix of dimension NxN indicating the mass of the first N-checkerboad copula}

\item{B}{Numeric matrix of dimension NxN indicating the mass of the second N-checkerboad copula}

\item{X}{Numeric vector of values in the first coordinate}

\item{Y}{Numeric vector of values in the second coordinate}
}
\value{
\code{D1()} returns the D1 distance, introduced in (Trutschnig, 2011).

\code{D1.ECBC()} returns the D1-distance between to checkerboard copulas A and B with same resolution

\code{zeta1()} returns the directed dependence from x to y.
}
\description{
Computation of the D1 distance between two checkerboard copulas A and B, corresponding to the random vectors (X1,Y1) and (X2,Y2), respectively.
The function \code{D1()} computes the difference between the dependence structures of two random vectors. The function \code{D1.ECBC()} computes the D1-distance between two checkerboard copulas with the same resolution.
The function \code{zeta1()} is defined as 3D1(A,Pi), where Pi denotes the independence copula and returns the dependence measure computed in qad.
}
\examples{

n <- 100
x1 <- runif(n)
y1 <- x1
x2 <- runif(n)
y2 <- 1-x2
D1(x1,y1,x2,y2)

n <- 1000
x <- runif(n, 0, 1)
y1 <- ifelse(x < 0.5, runif(length(x < 0.5), 0,0.5), runif(length(x >= 0.5), 0.5, 1))
y2 <- ifelse(x > 0.5, runif(length(x < 0.5), 0,0.5), runif(length(x >= 0.5), 0.5, 1))
A <- ECBC(x,y1, resolution = 50)
B <- ECBC(x,y2, resolution = 50)
#plot_density(A)
#plot_density(B)
D1.ECBC(A,B)
}
\references{
Trutschnig, W. (2011). On a strong metric on the space of copulas and its induced dependence measure. Journal of Mathematical Analysis and Applications. 384 (2), 690-705.

Junker, R.R., Griessenberger, F. and Trutschnig, W. (2021). Estimating scale-invariant directed dependence of bivariate distributions. Computational Statistics and Data Analysis, 153, 107058.
}
