% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_postal_code.R
\name{rm_postal_code}
\alias{rm_postal_code}
\alias{ex_postal_code}
\title{Remove/Replace/Extract Postal Codes}
\usage{
rm_postal_code(
  text.var,
  trim = !extract,
  clean = TRUE,
  pattern = "@rm_postal_code",
  replacement = "",
  extract = FALSE,
  dictionary = getOption("regex.library"),
  ...
)

ex_postal_code(
  text.var,
  trim = !extract,
  clean = TRUE,
  pattern = "@rm_postal_code",
  replacement = "",
  extract = TRUE,
  dictionary = getOption("regex.library"),
  ...
)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white 
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped 
character will be removed.}

\item{pattern}{A character string containing a regular expression (or 
character string for \code{fixed = TRUE}) to be matched in the given 
character vector.  Default, \code{@rm_postal_code} uses the 
\code{rm_postal_code} regex from the regular expression dictionary from 
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the city & state are extracted into a 
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within 
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with postal codes removed.
}
\description{
Remove/replace/extract postal codes.
}
\examples{
x <- c("Anchorage, AK", "New York City, NY", "Some Place, Another Place, LA")
rm_postal_code(x)
ex_postal_code(x)
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}

Other rm_ functions: 
\code{\link{rm_abbreviation}()},
\code{\link{rm_between}()},
\code{\link{rm_bracket}()},
\code{\link{rm_caps_phrase}()},
\code{\link{rm_caps}()},
\code{\link{rm_citation_tex}()},
\code{\link{rm_citation}()},
\code{\link{rm_city_state_zip}()},
\code{\link{rm_city_state}()},
\code{\link{rm_date}()},
\code{\link{rm_default}()},
\code{\link{rm_dollar}()},
\code{\link{rm_email}()},
\code{\link{rm_emoticon}()},
\code{\link{rm_endmark}()},
\code{\link{rm_hash}()},
\code{\link{rm_nchar_words}()},
\code{\link{rm_non_ascii}()},
\code{\link{rm_non_words}()},
\code{\link{rm_number}()},
\code{\link{rm_percent}()},
\code{\link{rm_phone}()},
\code{\link{rm_repeated_characters}()},
\code{\link{rm_repeated_phrases}()},
\code{\link{rm_repeated_words}()},
\code{\link{rm_tag}()},
\code{\link{rm_time}()},
\code{\link{rm_title_name}()},
\code{\link{rm_url}()},
\code{\link{rm_white}()},
\code{\link{rm_zip}()}
}
\concept{rm_ functions}
